<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCountySecretaryRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_county_secretary:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_county_secretary:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCountySecretaryRepository::class)
 */

class TCountySecretary
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_county_secretary:read", "t_county_secretary:write", "t_pcs:read" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyStaffMembers::class, inversedBy="tCountySecretaries")
     * @Groups({ "t_county_secretary:read", "t_county_secretary:write" })
     */
    private $staffMember;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({ "t_county_secretary:read", "t_county_secretary:write" })
     */
    private $currentStaff;

    /**
     * @ORM\OneToMany(targetEntity=TPcs::class, mappedBy="countySecWitnessCecPc")
     */
    private $tPcsCecPc;

    /**
     * @ORM\OneToMany(targetEntity=TPcs::class, mappedBy="countySecWitnessCoPc")
     */
    private $tPcs;

    public function __construct()
    {
        $this->tPcs = new ArrayCollection();
        $this->tPcsCecPc = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStaffMember(): ?TCountyStaffMembers
    {
        return $this->staffMember;
    }

    public function setStaffMember(?TCountyStaffMembers $staffMember): self
    {
        $this->staffMember = $staffMember;

        return $this;
    }

    public function getCurrentStaff(): ?string
    {
        return $this->currentStaff;
    }

    public function setCurrentStaff(?string $currentStaff): self
    {
        $this->currentStaff = $currentStaff;

        return $this;
    }

    /**
     * @return Collection|TPcs[]
     */
    public function getTPcsCecPc(): Collection
    {
        return $this->tPcsCecPc;
    }

    public function addTPcsCecPc(TPcs $tPcsCecPc): self
    {
        if (!$this->tPcsCecPc->contains($tPcsCecPc)) {
            $this->tPcsCecPc[] = $tPcsCecPc;
            $tPcsCecPc->setCountySecWitnessCecPc($this);
        }

        return $this;
    }

    public function removeTPcsCecPc(TPcs $tPcsCecPc): self
    {
        if ($this->tPcsCecPc->removeElement($tPcsCecPc)) {
            // set the owning side to null (unless already changed)
            if ($tPcsCecPc->getCountySecWitnessCecPc() === $this) {
                $tPcsCecPc->setCountySecWitnessCecPc(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TPcs[]
     */
    public function getTPcs(): Collection
    {
        return $this->tPcs;
    }

    public function addTPc(TPcs $tPc): self
    {
        if (!$this->tPcs->contains($tPc)) {
            $this->tPcs[] = $tPc;
            $tPc->setCountySecWitnessCoPc($this);
        }

        return $this;
    }

    public function removeTPc(TPcs $tPc): self
    {
        if ($this->tPcs->removeElement($tPc)) {
            // set the owning side to null (unless already changed)
            if ($tPc->getCountySecWitnessCoPc() === $this) {
                $tPc->setCountySecWitnessCoPc(null);
            }
        }

        return $this;
    }

    
}
