<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TKfasRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_kfas:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_kfas:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "kpa": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TKfasRepository::class)
 */

class TKfas
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_kfas:read", "t_kfas:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_kfas:read", "t_kfas:write" })
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity=TPcMatrix::class, mappedBy="kfa")
     */
    private $tPcMatrices;

    /**
     * @ORM\ManyToOne(targetEntity=TKpas::class, inversedBy="tKfas")
     * @Groups({ "t_kfas:read", "t_kfas:write" })
     */
    private $kpa;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_kfas:read", "t_kfas:write" })
     */
    private $code;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_kfas:read", "t_kfas:write" })
     */
    private $weight;

    public function __construct()
    {
        $this->tPcs = new ArrayCollection();
        $this->tPcMatrices = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Collection|TPcMatrix[]
     */
    public function getTPcMatrices(): Collection
    {
        return $this->tPcMatrices;
    }

    public function addTPcMatrix(TPcMatrix $tPcMatrix): self
    {
        if (!$this->tPcMatrices->contains($tPcMatrix)) {
            $this->tPcMatrices[] = $tPcMatrix;
            $tPcMatrix->setKfa($this);
        }

        return $this;
    }

    public function removeTPcMatrix(TPcMatrix $tPcMatrix): self
    {
        if ($this->tPcMatrices->removeElement($tPcMatrix)) {
            // set the owning side to null (unless already changed)
            if ($tPcMatrix->getKfa() === $this) {
                $tPcMatrix->setKfa(null);
            }
        }

        return $this;
    }

    public function getKpa(): ?TKpas
    {
        return $this->kpa;
    }

    public function setKpa(?TKpas $kpa): self
    {
        $this->kpa = $kpa;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): self
    {
        $this->code = $code;

        return $this;
    }

    public function getWeight(): ?string
    {
        return $this->weight;
    }

    public function setWeight(?string $weight): self
    {
        $this->weight = $weight;

        return $this;
    }

}
