<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TResponsibilitiesRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_responsibilities:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_responsibilities:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "sector": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TResponsibilitiesRepository::class)
 */

class TResponsibilities
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_responsibilities:read", "t_responsibilities:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_responsibilities:read", "t_responsibilities:write" })
     */
    private $name;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tResponsibilities")
     * @Groups({ "t_responsibilities:read", "t_responsibilities:write" })
     */
    private $sector;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }
}
