<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TSectorObjectivesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_sector_objectives:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_sector_objectives:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "sector": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TSectorObjectivesRepository::class)
 */

class TSectorObjectives
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_sector_objectives:read", "t_sector_objectives:write", "t_cidps:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_sector_objectives:read", "t_sector_objectives:write", "t_cidps:read" })
     */
    private $objectiveCode;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_sector_objectives:read", "t_sector_objectives:write", "t_directorate_objectives:read" })
     */
    private $objectiveName;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_sector_objectives:read", "t_sector_objectives:write" })
     */
    private $weight;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_sector_objectives:read", "t_sector_objectives:write" })
     */
    private $budgetAllocated;

    /**
     * @ORM\ManyToOne(targetEntity=TFinancialYears::class, inversedBy="tSectorObjectives")
     * @Groups({ "t_sector_objectives:read", "t_sector_objectives:write" })
     */
    private $financialYear;

    /**
     * @ORM\OneToMany(targetEntity=TDirectorateObjectives::class, mappedBy="sectorObjective")
     * @Groups({ "t_sector_objectives:read", "t_sector_objectives:write" })
     */
    private $tDirectorateObjectives;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tSectorObjectives")
     * @Groups({ "t_sector_objectives:read", "t_sector_objectives:write" })
     */
    private $sector;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_sector_objectives:read", "t_sector_objectives:write" })
     */
    private $outcome;

    /**
     * @ORM\ManyToOne(targetEntity=TSectorPriorities::class, inversedBy="tSectorObjectives")
     * @Groups({ "t_sector_objectives:read", "t_sector_objectives:write" })
     */
    private $sectorPriority;

    /**
     * @ORM\OneToMany(targetEntity=TCidps::class, mappedBy="sectorObjective")
     */
    private $tCidps;

    public function __construct()
    {
        $this->tDirectorateObjectives = new ArrayCollection();
        $this->tCidps = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getObjectiveCode(): ?string
    {
        return $this->objectiveCode;
    }

    public function setObjectiveCode(?string $objectiveCode): self
    {
        $this->objectiveCode = $objectiveCode;

        return $this;
    }

    public function getObjectiveName(): ?string
    {
        return $this->objectiveName;
    }

    public function setObjectiveName(?string $objectiveName): self
    {
        $this->objectiveName = $objectiveName;

        return $this;
    }

    public function getWeight(): ?string
    {
        return $this->weight;
    }

    public function setWeight(?string $weight): self
    {
        $this->weight = $weight;

        return $this;
    }

    public function getBudgetAllocated(): ?string
    {
        return $this->budgetAllocated;
    }

    public function setBudgetAllocated(?string $budgetAllocated): self
    {
        $this->budgetAllocated = $budgetAllocated;

        return $this;
    }

    public function getFinancialYear(): ?TFinancialYears
    {
        return $this->financialYear;
    }

    public function setFinancialYear(?TFinancialYears $financialYear): self
    {
        $this->financialYear = $financialYear;

        return $this;
    }

    /**
     * @return Collection|TDirectorateObjectives[]
     */
    public function getTDirectorateObjectives(): Collection
    {
        return $this->tDirectorateObjectives;
    }

    public function addTDirectorateObjective(TDirectorateObjectives $tDirectorateObjective): self
    {
        if (!$this->tDirectorateObjectives->contains($tDirectorateObjective)) {
            $this->tDirectorateObjectives[] = $tDirectorateObjective;
            $tDirectorateObjective->setSectorObjective($this);
        }

        return $this;
    }

    public function removeTDirectorateObjective(TDirectorateObjectives $tDirectorateObjective): self
    {
        if ($this->tDirectorateObjectives->removeElement($tDirectorateObjective)) {
            // set the owning side to null (unless already changed)
            if ($tDirectorateObjective->getSectorObjective() === $this) {
                $tDirectorateObjective->setSectorObjective(null);
            }
        }

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }

    public function getOutcome(): ?string
    {
        return $this->outcome;
    }

    public function setOutcome(?string $outcome): self
    {
        $this->outcome = $outcome;

        return $this;
    }

    public function getSectorPriority(): ?TSectorPriorities
    {
        return $this->sectorPriority;
    }

    public function setSectorPriority(?TSectorPriorities $sectorPriority): self
    {
        $this->sectorPriority = $sectorPriority;

        return $this;
    }

    /**
     * @return Collection|TCidps[]
     */
    public function getTCidps(): Collection
    {
        return $this->tCidps;
    }

    public function addTCidp(TCidps $tCidp): self
    {
        if (!$this->tCidps->contains($tCidp)) {
            $this->tCidps[] = $tCidp;
            $tCidp->setSectorObjective($this);
        }

        return $this;
    }

    public function removeTCidp(TCidps $tCidp): self
    {
        if ($this->tCidps->removeElement($tCidp)) {
            // set the owning side to null (unless already changed)
            if ($tCidp->getSectorObjective() === $this) {
                $tCidp->setSectorObjective(null);
            }
        }

        return $this;
    }
}
